/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.core;

import java.io.Serializable;
import java.util.ArrayList;
import weka.classifiers.rules.lad.binarization.Cutpoints;
import weka.classifiers.rules.lad.core.BinaryInstance;
import weka.core.Instance;
import weka.core.Instances;

public class BinaryData
implements Serializable {
    private static final long serialVersionUID = 2488234257854645289L;
    private ArrayList<BinaryInstance> mbIArrayPositive = new ArrayList();
    private ArrayList<BinaryInstance> mbIArrayNegative = new ArrayList();
    private Cutpoints sCutpoints;

    public BinaryData(Instances data, Cutpoints cutpoints) {
        this();
        for (Instance instance : data) {
            this.addInstance(new BinaryInstance(instance, cutpoints));
        }
        this.sCutpoints = cutpoints;
    }

    public BinaryData() {
    }

    public BinaryData(BinaryData bInsts) {
        this();
        for (BinaryInstance bInst : bInsts.mbIArrayPositive) {
            this.addInstance(bInst);
        }
        for (BinaryInstance bInst : bInsts.mbIArrayNegative) {
            this.addInstance(bInst);
        }
    }

    public void addInstance(BinaryInstance bInst) {
        if (bInst == null) {
            return;
        }
        if (bInst.instanceClass()) {
            this.mbIArrayPositive.add(bInst);
        } else {
            this.mbIArrayNegative.add(bInst);
        }
    }

    public void removeInstance(BinaryInstance bInst) {
        if (bInst.instanceClass()) {
            this.mbIArrayPositive.remove(bInst);
        } else {
            this.mbIArrayNegative.remove(bInst);
        }
    }

    public BinaryInstance getInstance(int index) {
        if (index < this.mbIArrayPositive.size()) {
            return this.mbIArrayPositive.get(index);
        }
        return this.mbIArrayNegative.get(index - this.mbIArrayPositive.size());
    }

    public BinaryInstance getPositiveInstance(int index) {
        return this.mbIArrayPositive.get(index);
    }

    public BinaryInstance getNegativeInstance(int index) {
        return this.mbIArrayNegative.get(index);
    }

    public final ArrayList<BinaryInstance> getPositiveInstances() {
        return this.mbIArrayPositive;
    }

    public final ArrayList<BinaryInstance> getNegativeInstances() {
        return this.mbIArrayNegative;
    }

    public int numInstances() {
        return this.numPositiveInstances() + this.numNegativeInstances();
    }

    public int numPositiveInstances() {
        return this.mbIArrayPositive.size();
    }

    public int numNegativeInstances() {
        return this.mbIArrayNegative.size();
    }

    public int numAttributes() {
        return this.sCutpoints.numCutpoints();
    }

    public String toString() {
        String s = "";
        for (BinaryInstance b : this.mbIArrayPositive) {
            s = String.valueOf(s) + b + "\n";
        }
        for (BinaryInstance b : this.mbIArrayNegative) {
            s = String.valueOf(s) + b + "\n";
        }
        return s;
    }
}

